<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Print Invoice #{{ $invoice->id }}</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            font-size: 10pt;
            background-color: #fff;
        }

        table {
            border: 1px solid #000;
            border-collapse: collapse;
        }

        table td table {
            border: none;
            border-collapse: collapse;
        }
    </style>
</head>
<body>
<span style="font-size: 14pt;font-weight: 900;"><strong>{{ $store->name}}</strong></span><br/>
<span style="font-size: 14pt;font-weight: 900;"><strong> {{ $store->first_address }}</strong> <br/>
        @if(!empty($store->second_address))
          <strong>{{ $store->second_address }}</strong>  <br/>
        @endif
    @if(!empty($store->contact_number))
        <span style="font-size: 14pt;font-weight: 900;"><strong>{{ $store->contact_number }}</strong></span> <br/>
    @endif
    </span>

<br/><br/>
<h4 align="center">INVOICE</h4>
<table width="100%" style="width: 100%">
    <tr>
        <td style="width: 40%; vertical-align: top;" valign="top">
            <table style="width: 100%;">
                <tr>
                    <td style="height: 152px;vertical-align: top;border:1px solid #000;border-right: none;" valign="top">
                        <strong>{{ $invoice->created_user->name }}</strong><br/>

                    </td>
                </tr>
                <tr>
                    <td style="height: 155px;vertical-align: top;border:1px solid #000; border-bottom: none;border-right: none;" valign="top">
                        Buyer (Bill to)<br/>
                        <strong>{{ $invoice->customer->firstname }} {{ $invoice->customer->lastname }}</strong><br>
                       {{ $invoice->customer->address }}
                    </td>
                </tr>
            </table>
        </td>
        <td style="width: 60%; vertical-align: top;margin:0;padding: 0" valign="top">

            <table style="width: 100%">
                <tr>
                    <td style="border:1px solid #000;">
                        Invoice No <br/><br/>
                        <span style="margin-top: 5px;">{{ $invoice->invoice_paper_number }}</span>
                    </td>
                    <td style="border:1px solid #000;">
                        Dated<br/><br/>
                        <span style="margin-top: 5px;">{{ convert_date2($invoice->invoice_date)  }}</span>
                    </td>
                </tr>
                <tr>
                    <td style="border:1px solid #000;">
                        Reference No. & Date<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                    <td style="border:1px solid #000;">
                        Other Reference<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                </tr>
                <tr>
                    <td style="border:1px solid #000;">
                        Buyer's Order No<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                    <td style="border:1px solid #000;">
                       Dated<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                </tr>
                <tr>
                    <td style="border:1px solid #000;">
                       Dispatch Doc No.<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                    <td style="border:1px solid #000;">
                        Delivery Note Date<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                </tr>
                <tr>
                    <td style="border:1px solid #000;">
                        Dispatch through<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                    <td style="border:1px solid #000;">
                        Destination<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="width: 100%;border:1px solid #000;border-bottom: none">
                        Terms of Delivery<br/><br/><br/><br/>
                        <span style="margin-top: 15px;"></span>
                    </td>

                </tr>
            </table>

        </td>
    </tr>
</table>
<table width="100%"  style="width: 100%; height: 600px;">
    <thead>
    <tr>
        <th style="text-align: center; width: 5%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">SN</th>
        <th style="text-align: center; width: 45%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">Description of Goods</th>
        <th style="text-align: center; width: 10%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">Quantity</th>
        <th style="text-align: center;width: 10%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">Rate</th>
        <th style="text-align: center;width: 10%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">per</th>
        <th style="text-align: center;width: 10%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">Disc %</th>
        <th style="text-align: center;width: 10%;font-size: 10pt;border-right:1px solid  #000;border-bottom: 1px solid #000">Amount</th>
    </tr>
    </thead>
    <tbody>
    @php
        $num = 1;
    @endphp
    @foreach($invoice->invoice_items as $item)
    <tr>
        <td style="text-align: center; width: 5%; padding-top: 15px; padding-bottom: 5px; border-right:1px solid  #000;"><strong>{{ $loop->iteration }}</strong></td>
        <td style="text-align: center; width: 40%;border-right:1px solid  #000;"><strong>{{ $item->stock->name }}</strong></td>
        <td style="text-align: center; width: 10%;border-right:1px solid  #000;"><strong>{{ number_format($item->quantity,0) }}</strong></td>
        <td style="text-align: center;width: 10%;border-right:1px solid  #000;">{{ number_format($item->selling_price,2) }}</td>
        <td style="text-align: center;width: 10%;border-right:1px solid  #000;">bx</td>
        <td style="text-align: center;width: 10%;border-right:1px solid  #000;"></td>
        <td style="text-align: center;width: 15%;border-right:1px solid  #000;"><strong>{{ number_format($item->total_selling_price,2) }}</strong></td>
    </tr>
    @php
        $num +=$item->quantity;
    @endphp
    @endforeach
    </tbody>
    <tfoot>
    <tr>
        <td style="text-align: center; width: 5%;border-right:1px solid  #000;border-top: 1px solid #000"></td>
        <th style="text-align: right; width: 45%;font-size: 9pt;border-right:1px solid  #000;border-top: 1px solid #000">Total</th>
        <td style="text-align: center; width: 10%;border-right:1px solid  #000;border-top: 1px solid #000"></td>
        <td style="text-align: center;width: 10%;border-right:1px solid  #000;border-top: 1px solid #000"></td>
        <td style="text-align: center;width: 10%;border-right:1px solid  #000;border-top: 1px solid #000"></td>
        <td style="text-align: center;width: 10%;border-right:1px solid  #000;border-top: 1px solid #000"></td>
        <th style="text-align: center;width: 10%;border-right:1px solid  #000;border-top: 1px solid #000font-size: 9pt;border-top: 1px solid #000">nn {{ number_format($invoice->sub_total,2) }}</th>
    </tr>
    </tfoot>
</table>
<table style="width: 100%;height: 150px;border:1px solid #000;">
    <tr>
        <td style="width: 50%; border:none">
            Amount Chargeable (in words)
            <b>Nigerian Naira {{ numberTowords($invoice->sub_total) }} only</b>
            <br/> <br/>
        </td>
        <td style="width: 50%; text-align: right; border:none">
            E. & O.E
            <br/> <br/>
        </td>
    </tr>
</table>
<table style="width: 100%;height: 50px; border:none;">
    <tr>
        <td style="width: 50%; border:1px solid #000;">
            Remarks<br/>
            **From {{ $invoice->customer->firstname }} {{ $invoice->customer->lastname }} ***
            <br/>
            <u>Declaration</u><br/>
            NO RETURNS of items will be accepted. This includes NO<br/>
            REFUNDS and NO EXCHANGES of goods once they have left our premises
        </td>
        <td valign="top" style="width: 50%; text-align: right; border: 1px solid #000; vertical-align: top;border-top:1px solid #000">

            <br/>
            <br/>
            <br/>
            <br/>
            Authorised Signatory
        </td>
    </tr>
</table>
<div align="center">This is a Computed Generated Invoice</div>
</body>
</html>

