<?php $__env->startSection('content'); ?>
    <div class="ui-container">
        <div class="row">
            <div class="col-md-8">
                <section class="panel">
                    <header class="panel-heading">
                        <?php echo e($title); ?>

                    </header>
                    <div class="panel-body">
                        <?php if(session('success')): ?>
                            <?php echo alert_success(session('success')); ?>

                        <?php elseif(session('error')): ?>
                            <?php echo alert_error(session('error')); ?>

                        <?php endif; ?>
                            <table class="table table-hover table-hover">
                                <tr>
                                    <th>#</th>
                                    <th>Full name</th>
                                    <th>Username</th>
                                    <th>Email Address</th>
                                    <th>Address</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                <?php $__currentLoopData = $reps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($rep->fullname); ?></td>
                                        <td><?php echo e($rep->username); ?></td>
                                        <td><?php echo e($rep->email_address); ?></td>
                                        <td><?php echo e($rep->address); ?></td>
                                        <td><?php echo $rep->status == 1 ? label("Active","success") : label("Inactive","danger"); ?></td>
                                        <td>
                                            <?php if(userCanView('sales_representative.toggle')): ?>
                                                <?php if($rep->status == 1): ?>
                                                    <a href="<?php echo e(route('sales_representative.toggle',$rep->id)); ?>" class="btn btn-danger btn-sm">Disable</a>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('sales_representative.toggle',$rep->id)); ?>" class="btn btn-success btn-sm">Enable</a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                                <?php if(userCanView('sales_representative.edit')): ?>
                                                    <a href="<?php echo e(route('sales_representative.edit',$rep->id)); ?>" class="btn btn-success btn-sm">Edit</a>
                                                <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                    </div>
                </section>
            </div>
            <?php if(userCanView('bank.create')): ?>
                <div class="col-md-4">
                <section class="panel">
                    <header class="panel-heading">
                        <?php echo e($title2); ?>

                    </header>
                    <div class="panel-body">
                        <form id="validate" action="<?php echo e(route('sales_representative.store')); ?>" enctype="multipart/form-data" method="post">
                            <?php echo e(csrf_field()); ?>

                            <div class="form-group">
                                <label>Full Name</label>
                                <input type="text" value="<?php echo e(old('fullname')); ?>" required  class="form-control" name="fullname" placeholder="Full Name"/>
                                <?php if($errors->has('fullname')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('fullname')); ?></label>
                                <?php endif; ?>
                            </div>


                            <div class="form-group">
                                <label>Username</label>
                                <input type="text" value="<?php echo e(old('username')); ?>" required  class="form-control" name="username" placeholder="Username"/>
                                <?php if($errors->has('username')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('username')); ?></label>
                                <?php endif; ?>
                            </div>



                            <div class="form-group">
                                <label>Email Address</label>
                                <input type="text" value="<?php echo e(old('email_address')); ?>" required  class="form-control" name="email_address" placeholder="Email Address"/>
                                <?php if($errors->has('email_address')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('email_address')); ?></label>
                                <?php endif; ?>
                            </div>


                            <div class="form-group">
                                <label>Address</label>
                                <input type="text" value="<?php echo e(old('address')); ?>" required  class="form-control" name="address" placeholder="Address"/>
                                <?php if($errors->has('address')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('address')); ?></label>
                                <?php endif; ?>
                            </div>


                            <div class="pull-left">
                                <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                            </div>
                            <br/> <br/>
                        </form>
                    </div>
                </section>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salespoint\resources\views/settings/sales_representative/list-rep.blade.php ENDPATH**/ ?>