<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/select2/dist/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker3.min.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
    <div class="ui-container">
        <div class="row">
            <div class="col-md-5">
                <section class="panel">
                    <header class="panel-heading">
                        <?php echo e($title); ?>

                    </header>
                    <div class="panel-body">
                        <?php if(isset($transaction->id)): ?>
                            <form action="<?php echo e(route('cashbook.update',$transaction->id)); ?>"   method="post">
                                <?php echo e(method_field('PUT')); ?>

                                <?php else: ?>
                                    <form action="<?php echo e(route('cashbook.store')); ?>" method="post">
                                        <?php endif; ?>
                                        <?php echo e(csrf_field()); ?>

                                        <div class="form-group">
                                            <label for="price">Date</label>
                                            <input id="transaction_date" type="text" value="<?php echo date('Y-m-d'); ?>" name="transaction_date" data-min-view="2" data-date-format="yyyy-mm-dd"  placeholder="Date" class="form-control datepicker js-datepicker">
                                        </div>
                                        <div class="form-group">
                                            <label>Transaction Type</label>
                                            <select required class="form-control" name="type">
                                                <option <?php echo e(old('type',$transaction->type) == "Credit" ? "selected" : ""); ?> value="Credit">Credit</option>
                                                <option <?php echo e(old('type',$transaction->type) == "Debit" ? "selected" : ""); ?> value="Debit">Debit</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Select Bank</label>
                                            <select required class="form-control input-sm" name="bank_account_id">
                                                <option value="">Select Bank</option>
                                                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(old('bank_account_id',$transaction->bank_account_id) ==  $bank->id ? "selected" : ""); ?> value="<?php echo e($bank->id); ?>"><?php echo e($bank->bank->name); ?> - <?php echo e($bank->account_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Transaction Amount</label>
                                            <input class="form-control input-sm" value="<?php echo e(old('amount',$transaction->amount)); ?>" name="amount" placeholder="Transaction Amount"  step="0.00000000000000000000" type="number"/>
                                        </div>
                                        <div class="form-group">
                                            <label>More Description / Reference</label>
                                            <textarea class="form-control input-sm" tabindex="-6" required placeholder="More Description / Reference" name="comment"><?php echo e(old('comment',$transaction->comment)); ?></textarea>
                                        </div>
                                        <button type="submit"  class="btn btn-primary"> Save</button>
                                    </form>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/select2/dist/js/select2.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('assets/js/init-select2.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script  src="<?php echo e(asset('assets/js/init-datepicker.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salespoint\resources\views/cashbook/new-transaction.blade.php ENDPATH**/ ?>