<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/select2/dist/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker3.min.css')); ?>">
    <link href="<?php echo e(asset('bower_components/datatables/media/css/jquery.dataTables.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-tabletools/css/dataTables.tableTools.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-colvis/css/dataTables.colVis.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-responsive/css/responsive.dataTables.scss')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-scroller/css/scroller.dataTables.scss')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
    <div class="ui-container">
        <div class="row">
            <div class="col-md-9">
                <section class="panel">
                    <?php if(session('success')): ?>
                        <?php echo alert_success(session('success')); ?>

                    <?php elseif(session('error')): ?>
                        <?php echo alert_error(session('error')); ?>

                    <?php endif; ?>
                    <div class="panel-heading">
                        <?php echo e($title2); ?>

                    </div>
                    <div class="panel-body">
                        <table class="table table-bordered table-responsive table convert-data-table table-striped" style="font-size: 10px">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Stock</th>
                                <th>Quantity</th>
                                <th>Date</th>
                                <th>Product Type</th>
                                <th>Usage Type</th>
                                <th>Department</th>
                                <th>Selling Price</th>
                                <th>Cost Price</th>
                                <th>By</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($log->stock->name); ?></td>
                                    <td><?php echo e($log->quantity); ?></td>
                                    <td><?php echo e(convert_date2($log->log_date)); ?></td>
                                    <td><?php echo e(array_search($log->product_type,config('stock_type_name.'.config('app.store')))); ?></td>
                                    <td><?php echo e($log->usage_type); ?></td>
                                    <td><?php echo e($log->department); ?></td>
                                    <td><?php echo e(number_format($log->selling_price,2)); ?></td>
                                    <td><?php echo e(number_format($log->cost_price,2)); ?></td>
                                    <td><?php echo e($log->user->name); ?></td>
                                    <td>
                                        <?php if(userCanView('stocklog.edit',$log->id)): ?>
                                            <a href="<?php echo e(route('stocklog.edit',$log->id)); ?>" class="btn btn-primary btn-sm">Edit</a>
                                        <?php endif; ?>
                                        <?php if(userCanView('stocklog.delete_log',$log->id)): ?>
                                            <a href="<?php echo e(route('stocklog.delete_log',$log->id)); ?>" class="btn btn-danger btn-sm">Delete</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                 <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
            <div class="col-md-3">
                <section class="panel">
                    <div class="panel-heading">
                        <?php echo e($title); ?>

                    </div>
                    <div class="panel-body">
                        <form  action="<?php echo e(route('stocklog.add_log')); ?>" enctype="multipart/form-data" method="post">
                            <?php echo e(csrf_field()); ?>

                            <div class="form-group">
                                <label>Select Stock</label>
                                <select name="stock_id"  class="form-control select2" id="products">
                                    <option value="">-Select One-</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label style="white-space: nowrap;">Quantity</label>
                                <input required type="number" name="qty" placeholder="Quantity" class="form-control" id="qty"/>
                            </div>

                            <div class="form-group" >
                                <label>Select Usage Type</label>
                                <select required id="usage_type" name="usage_type" class="form-control">
                                    <?php if(config('app.store') == "hotel"): ?>
                                    <option value="">-Select One-</option>
                                    <?php endif; ?>
                                    <option value="DAMAGES">DAMAGES</option>
                                    <?php if(config('app.store') == "hotel"): ?>
                                        <option value="USED">IN-STORE USED</option>
                                    <?php endif; ?>
                                </select>
                                <?php if($errors->has('usage_type')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('supplier')); ?></label>
                                <?php endif; ?>
                            </div>

                            <?php if(config('app.store') == "hotel"): ?>
                                <div cclass="form-group">
                                    <label>Select Department</label>
                                    <select required id="department" name="department" class="form-control select2">
                                        <?php $__currentLoopData = config('app.departments.'.config('app.store')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option  value="<?php echo e($department); ?>"><?php echo e($department); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('department')): ?>
                                        <label for="name-error" class="error"
                                               style="display: inline-block;"><?php echo e($errors->first('department')); ?></label>
                                    <?php endif; ?>
                                    <input type="hidden" id="product_type" name="product_type" value="BAR STOCK" />
                                </div>
                            <?php else: ?>
                                <div class="form-group">
                                    <label>Select Product Type</label>
                                    <select required id="product_type" name="product_type" class="form-control select2">
                                        <?php $__currentLoopData = config('stock_type_name.'.config('app.store')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option  value="<?php echo e($type); ?>"><?php echo e($key); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('product_type')): ?>
                                        <label for="name-error" class="error"
                                               style="display: inline-block;"><?php echo e($errors->first('product_type')); ?></label>
                                    <?php endif; ?>
                                </div>
                                <input type="hidden" id="department" name="department" value="STORE" />
                            <?php endif; ?>

                            <div class="form-group">
                                <label>Select Store</label>
                                <select required id="store" name="store" class="form-control select2">
                                    <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option  value="<?php echo e($store->id); ?>"><?php echo e($store->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('store')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('store')); ?></label>
                                <?php endif; ?>
                            </div>
                            <div class="form-group">
                                <label>Date</label>
                                <input class="form-control datepicker js-datepicker" data-min-view="2" data-date-format="yyyy-mm-dd" style="background-color: #FFF; color: #000;"  name="date_created" value="<?php echo e(\Carbon\Carbon::today()->toDateString()); ?>"/>
                                <?php if($errors->has('date_created')): ?>
                                    <label for="name-error" class="error"
                                           style="display: inline-block;"><?php echo e($errors->first('date_created')); ?></label>
                                <?php endif; ?>
                            </div>
                            <button class="btn btn-primary btn-lg" type="submit" name="save" value="save_and_create"><i class="fa fa-save"></i> Log Stock</button>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/select2/dist/js/select2.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('assets/js/init-select2.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-tabletools/js/dataTables.tableTools.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-colvis/js/dataTables.colVis.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-responsive/js/dataTables.responsive.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-scroller/js/dataTables.scroller.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/init-datatables.js')); ?>"></script>
    <script  src="<?php echo e(asset('assets/js/init-datepicker.js')); ?>"></script>
    <script>
        $(document).ready(function(e){
            var path = "<?php echo e(route('findselectstock')); ?>?select2=yes";
            var select =  $('#products').select2({
                placeholder: 'Search for product',
                ajax: {
                    url: path,
                    dataType: 'json',
                    delay: 250,
                    data: function (data) {
                        return {
                            searchTerm: data.term // search term
                        };
                    },
                    processResults: function (response) {
                        return {
                            results:response
                        };
                    },
                }
            });


            $("#products").on('change',function(eventData){
                var data = $(this).select2('data');
                data = data[0];
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salespoint\resources\views/stock/stocklog/form.blade.php ENDPATH**/ ?>