<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Activitylog\Traits\LogsActivity;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, LogsActivity;


    protected $casts = [
        'group_id' => 'int',
        'status' => 'bool'
    ];

    protected $dates = [
        'email_verified_at',
        'last_login'
    ];

    protected $hidden = [
        'password',
        'remember_token'
    ];

    protected $fillable = [
        'name',
        'username',
        'email',
        'group_id',
        'department',
        'warehousestore_id',
        'email_verified_at',
        'password',
        'status',
        'last_login',
        'remember_token'
    ];

    public static $profile_fields = [
        'name',
        'username',
        'email',
        'password',
    ];

    public static $rules = [
        'name' => 'required|string',
        'username' => 'required|string',
    ];

    public static $rules_update = [
        'name' => 'required|string',
        'username' => 'required|string',
    ];

    public function group()
    {
        return $this->belongsTo(Group::class);
    }

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub

        self::creating(function($user){
            $user->customer_id = 0;
            $user->customer_type = "   ";
        });

        self::created(function($user){

            if(config('app.store')  == "hotel"){
                $customer = new Customer();

                list($surname, $first_name) = array_pad(explode(' ', trim($user->name)), 2, null);

                $customer->firstname = $surname;
                $customer->lastname = $first_name;
                $customer->email = $user->email;

                $customer->save();

                $user->customer_id = $customer->id;
                $user->customer_type = "App\\Models\\Customer";

                $user->save();
            }

        });


        self::updated(function($user){
            if(config('app.store')  == "hotel") {
                if ($user->customer_id != "0") {
                    $customer = Customer::find($user->customer_id);

                    list($surname, $first_name) = array_pad(explode(' ', trim($user->name)), 2, null);

                    $customer->firstname = $surname;
                    $customer->lastname = $first_name;
                    $customer->email = $user->email;

                    $customer->save();

                }
            }
        });

    }


    public function warehousestore()
    {
        return $this->belongsTo(Warehousestore::class);
    }

    public function booking_reservation_items()
    {
        return $this->hasMany(BookingReservationItem::class);
    }

    public function booking_reservations()
    {
        return $this->hasMany(BookingReservation::class);
    }

    public function cashbooks()
    {
        return $this->hasMany(Cashbook::class);
    }

    public function credit_payment_logs()
    {
        return $this->hasMany(CreditPaymentLog::class);
    }

    public function customer_deposits_histories()
    {
        return $this->hasMany(CustomerDepositsHistory::class, 'last_updated_by');
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'voided_by');
    }

    public function payment_method_tables()
    {
        return $this->hasMany(PaymentMethodTable::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function purchase_order_items()
    {
        return $this->hasMany(PurchaseOrderItem::class, 'added_by');
    }

    public function purchase_orders()
    {
        return $this->hasMany(PurchaseOrder::class, 'updated_by');
    }

    public function return_logs()
    {
        return $this->hasMany(ReturnLog::class);
    }

    public function stock_log_items()
    {
        return $this->hasMany(StockLogItem::class);
    }

    public function stock_log_operations()
    {
        return $this->hasMany(StockLogOperation::class);
    }

    public function stock_taking_items()
    {
        return $this->hasMany(StockTakingItem::class);
    }

    public function stock_takings()
    {
        return $this->hasMany(StockTaking::class);
    }

    public function stock_transfer_items()
    {
        return $this->hasMany(StockTransferItem::class);
    }

    public function stock_transfers()
    {
        return $this->hasMany(StockTransfer::class);
    }

    public function stocks()
    {
        return $this->hasMany(Stock::class);
    }

    public function supplier_credit_payment_histories()
    {
        return $this->hasMany(SupplierCreditPaymentHistory::class);
    }
}
