<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/select2/dist/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker3.min.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
    <div class="ui-container">
        <div class="row">
            <div class=" col-md-offset-1 col-md-6">
                <?php if(session('success')): ?>
                    <?php echo alert_success(session('success')); ?>

                <?php elseif(session('error')): ?>
                    <?php echo alert_error(session('error')); ?>

                <?php endif; ?>
                <form action="" method="post">
                    <?php echo e(csrf_field()); ?>

                    <section class="panel">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-10">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Select Stock to Adjust</label>
                                        <select class="form-control  select-customer"  name="select_stock" id="customer_id">
                                            <option>Select Stock</option>
                                            <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e($select_stock == $stock->id ? 'selected' : ''); ?> value="<?php echo e($stock->id); ?>"><?php echo e($stock->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <br/>
                                    <input class="btn btn-info btn-sm" style="margin-top: 5px;" type="submit" name="save" value="Fetch Stock">
                                </div>
                            </div>
                        </div>
                    </section>
                </form>
            </div>

            <?php if(isset($convert_stock)): ?>
                <div class="col-md-6 col-md-offset-1">
                    <form action="" method="post">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="stock_id" value="<?php echo e($convert_stock->id); ?>"/>
                        <section class="panel">
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <h4>Stock Information</h4>
                                        <div class="form-group">
                                            <label style="font-size: 12px">Name</label><br/>
                                            <label style="font-size: 15px"><?php echo e($convert_stock->name); ?></label>
                                        </div>
                                        <div class="form-group">
                                            <label style="font-size: 12px">Available Quantity</label><br/>
                                            <label style="font-size: 15px"><?php echo e($convert_stock->available_quantity); ?></label>
                                        </div>
                                        <div class="form-group">
                                            <label style="font-size: 12px">Selling Price</label><br/>
                                            <label style="font-size: 15px"><?php echo e(number_format($convert_stock->selling_price,2)); ?></label>
                                        </div>
                                        <div class="form-group">
                                            <label style="font-size: 12px">Cost Price</label><br/>
                                            <label style="font-size: 15px"><?php echo e(number_format($convert_stock->cost_price,2)); ?></label>
                                        </div>
                                        <div class="form-group">
                                            <label style="font-size: 12px">Name</label><br/>
                                            <label style="font-size: 15px"><?php echo e($convert_stock->name); ?></label>
                                        </div>
                                        <div class="form-group">
                                            <label style="font-size: 12px">Available Yards Quantity</label><br/>
                                            <label style="font-size: 15px;"><?php echo e($convert_stock->available_yard_quantity); ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">

                                        <div class="form-group" >
                                            <label style="font-size: 12px">Enter New Packed Quantity</label><br/>
                                            <input type="number" value="<?php echo e($convert_stock->available_quantity); ?>"  class="form-control" name="packed_qty" placeholder="New Packed Quantity"/>
                                        </div>
                                        <div class="form-group">
                                            <label style="font-size: 12px"> Enter New Yard Quantity</label><br/>
                                            <input type="number" value="<?php echo e($convert_stock->available_yard_quantity); ?>"  class="form-control" name="yard_qty" placeholder="New Yard Quantity"/>
                                        </div>

                                        <input class="btn btn-info btn-block btn-lg" type="submit" name="save" value="Adjust">

                                    </div>
                                </div>
                            </div>
                        </section>
                    </form>
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/select2/dist/js/select2.min.js')); ?>"></script>
    <script  src="<?php echo e(asset('assets/js/init-select2.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salespoint\resources\views/stock/quick_adjust_qty.blade.php ENDPATH**/ ?>