<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/select2/dist/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker3.min.css')); ?>">
    <link href="<?php echo e(asset('bower_components/datatables/media/css/jquery.dataTables.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-tabletools/css/dataTables.tableTools.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-colvis/css/dataTables.colVis.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-responsive/css/responsive.dataTables.scss')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('bower_components/datatables-scroller/css/scroller.dataTables.scss')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="ui-container">
        <div class="row">
            <div class="col-md-12">
                <section class="panel">
                    <header class="panel-heading">
                        <?php echo e($title); ?>

                        <form action=""  class="tools pull-right" style="margin-right: 80px" method="post">
                            <?php echo e(csrf_field()); ?>

                            <div class="row">
                                <div class="col-sm-5">
                                    <label>From</label>
                                    <input type="text" class="form-control datepicker js-datepicker" data-min-view="2" data-date-format="yyyy-mm-dd" style="background-color: #FFF; color: #000;"  value="<?php echo e($from); ?>" name="from" placeholder="From"/>
                                </div>
                                <div class="col-sm-5">
                                    <label>To</label>
                                    <input type="text" class="form-control datepicker js-datepicker" data-min-view="2" data-date-format="yyyy-mm-dd" style="background-color: #FFF; color: #000;"  value="<?php echo e($to); ?>" name="to" placeholder="TO"/>
                                </div>
                                <div class="col-sm-2"><br/>
                                    <button type="submit" style="margin-top: 5px;" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </form>
                    </header>
                    <div class="panel-body">
                        <br/>  <br/>
                        <div class="row">
                            <div class="col-sm-4">
                                <h4>Report Summary</h4>
                                <table class="table table-bordered table-striped">
                                    <tr>
                                        <th>Total Quantity Transfer</th>
                                        <th><?php echo e($transfers->sum('quantity')); ?></th>
                                    </tr>
                                    <tr>
                                        <th>Total Quantity Sold</th>
                                        <th><?php echo e($sales->sum('quantity')); ?></th>
                                    </tr>
                                    <tr>
                                        <th>Total Quantity Purchases</th>
                                        <th><?php echo e($purchases->sum('qty')); ?></th>
                                    </tr>
                                    <tr>
                                        <th>Total Quantity  Returns</th>
                                        <th><?php echo e($returns->sum('quantity_before')); ?></th>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-sm-4"></div>
                            <div class="col-sm-4">
                                <h4>Quantity By Shop</h4>
                                <table class="table table-bordered table-striped">
                                    <tr>
                                        <th>#</th>
                                        <th>Warehouse & Shops</th>
                                        <th>Quantity Packed</th>
                                        <th>Quantity Yards</th>
                                    </tr>
                                    <?php $__currentLoopData = \App\Models\Warehousestore::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th><?php echo e($loop->iteration); ?></th>
                                            <th><?php echo e($shop->name); ?></th>
                                            <th><?php echo e($stock->getCustomPackedStockQuantity($shop->id)); ?></th>
                                            <th><?php echo e($stock->getCustomYardStockQuantity($shop->id)); ?></th>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>

                        <br/>  <br/>
                        <div class="row">
                            <div class="col-sm-12">
                                <h4>Product Transfer History</h4>
                                <table class="table table-bordered table-responsive table convert-data-table table-striped" style="font-size: 12px">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Product Type</th>
                                        <th>Total Cost Price</th>
                                        <th>By</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e($transfer->store_from->name); ?></td>
                                            <td><?php echo e($transfer->store_to->name); ?></td>
                                            <td><?php echo $transfer->stock_transfer->status == "COMPLETE" ? label( $transfer->stock_transfer->status,'success') : label( $transfer->status,'primary'); ?></td>
                                            <td><?php echo e(convert_date($transfer->transfer_date)); ?></td>
                                            <td><?php echo e(convert_date($transfer->product_type)); ?></td>
                                            <td><?php echo e(number_format($transfer->total_price,2)); ?></td>
                                            <td><?php echo e($transfer->user->name); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <br/>  <br/>
                        <div class="row">
                            <div class="col-sm-12">
                                <h4>Product Sales History</h4>
                                <table class="table table-bordered table-responsive table convert-data-table table-striped" style="font-size: 12px">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Invoice/Receipt No</th>
                                        <th>Customer</th>
                                        <th>Stock</th>
                                        <th>Qty Sold</th>
                                        <th>Total Cost Price</th>
                                        <th>Total Selling Price</th>
                                        <th>Profit</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Time</th>
                                        <th>By</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($invoice->invoice->invoice_paper_number); ?></td>
                                        <td><?php echo e($invoice->customer->firstname); ?> <?php echo e($invoice->customer->lastname); ?></td>
                                        <td><?php echo e($invoice->stock->name); ?></td>
                                        <td><?php echo e($invoice->quantity); ?></td>
                                        <td><?php echo e(number_format(($invoice->quantity * $invoice->cost_price),2)); ?></td>
                                        <td><?php echo e(number_format(($invoice->quantity * $invoice->selling_price),2)); ?></td>
                                        <td><?php echo e(number_format((($invoice->quantity * $invoice->selling_price)-($invoice->quantity * $invoice->cost_price)),2)); ?></td>
                                        <td><?php echo invoice_status($invoice->status); ?></td>
                                        <td><?php echo e(convert_date2($invoice->invoice->invoice_date)); ?></td>
                                        <td><?php echo e($invoice->invoice->sales_time); ?></td>
                                        <td><?php echo e($invoice->invoice->created_user->name); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <br/>  <br/>
                        <div class="row">
                            <div class="col-sm-12">
                                <h4>Product Purchase History</h4>
                                <table class="table table-bordered table-responsive table convert-data-table table-striped" style="font-size: 12px">
                                    <thead>
                                    <tr>
                                        <th>Supplier</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th class="text-center"><strong>Quantity</strong></th>
                                        <th class="text-center"><strong>Cost Price</strong></th>
                                        <th class="text-right"><strong>Total Cost Price</strong></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($item->purchase_order->supplier->name); ?></td>
                                            <td><?php echo e(convert_date2($item->purchase_order->date_created)); ?></td>
                                            <td><?php echo $item->purchase_order->status == "DRAFT" ? label('DRAFT','primary') :   label('COMPLETE','success'); ?></td>
                                            <td class="text-center"><?php echo e($item->qty); ?></td>
                                            <td class="text-center"><?php echo e(number_format($item->cost_price,2)); ?></td>
                                            <td class="text-right"><?php echo e(number_format(($item->cost_price * $item->qty),2)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <br/>  <br/>
                        <div class="row">
                            <div class="col-sm-12">
                                <h4>Product Returns History</h4>
                                <table class="table table-bordered table-responsive table convert-data-table table-striped" id="invoice-list" style="font-size: 12px">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Stock</th>
                                        <th>Customer</th>
                                        <th>Invoice / Receipt No</th>
                                        <th>Quantity</th>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Selling Price</th>
                                        <th>Return By</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e($log->stock->name); ?></td>
                                            <td><?php echo e($log->customer->firstname); ?> <?php echo e($log->customer->lastname); ?></td>
                                            <td><?php echo e($log->invoice_paper_number); ?></td>
                                            <td><?php echo e($log->quantity_before); ?></td>
                                            <td><?php echo e(convert_date2($log->date_added)); ?></td>
                                            <td><?php echo e($log->store_after == "quantity" ? "Packed" : "Pieces / Yards"); ?></td>
                                            <td><?php echo e(number_format($log->selling_price,2)); ?></td>
                                            <td><?php echo e($log->user->name); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </section>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/select2/dist/js/select2.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('assets/js/init-select2.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false" src="<?php echo e(asset('bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>"></script>

    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-tabletools/js/dataTables.tableTools.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-colvis/js/dataTables.colVis.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-responsive/js/dataTables.responsive.js')); ?>"></script>
    <script data-turbolinks-eval="false" data-turbo-eval="false"  src="<?php echo e(asset('bower_components/datatables-scroller/js/dataTables.scroller.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/init-datatables.js')); ?>"></script>
    <script  src="<?php echo e(asset('assets/js/init-datepicker.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salespoint\resources\views/stock/product_report.blade.php ENDPATH**/ ?>