<?php $__env->startSection('content'); ?>
    <div class="ui-container">
        <div class="row">
            <div class="col-md-10 col-md-offset-1">
                <section class="panel">
                    <div class="panel-heading">
                        <?php echo e($title); ?>

                    </div>
                    <div class="panel-body">
                        <div class="col-lg-12">
                            <?php if(session('success')): ?>
                                <?php echo alert_success(session('success')); ?>

                            <?php elseif(session('error')): ?>
                                <?php echo alert_error(session('error')); ?>

                            <?php endif; ?>
                        </div>
                        <div class="col-xs-12">
                            <div class="invoice-title">
                                <h2>Purchase Order</h2><h3 class="pull-right"> # <?php echo e($porder->id); ?></h3>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-xs-6">
                                    <address>
                                        <strong><?php echo e($settings->name); ?>:</strong><br>
                                        <?php echo e($settings->first_address); ?><br>
                                        Created By : <?php echo e($porder->created_user->name); ?><br>
                                        Date : <?php echo e(str_date($porder->date_created)); ?><br>
                                    </address>
                                </div>
                                <div class="col-xs-6 text-right"><strong>Supplier:</strong><br>
                                    <address>
                                        <?php echo e($porder->supplier->name); ?><br>
                                        <?php echo e($porder->supplier->address); ?><br>
                                        <?php echo e($porder->supplier->email); ?><br>
                                        <?php echo e($porder->supplier->phonenumber); ?>

                                    </address>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="panel-title"><strong>Purchase Order Items</strong></h3>
                                </div>
                                <div class="col-md-12">
                                    <br/>
                                    <div class="table-responsive">
                                        <table class="table table-condensed" id="stock-list">
                                            <thead>
                                            <tr>
                                                <td><strong>Name</strong></td>
                                                <td class="text-center"><strong>Quantity</strong></td>
                                                <td class="text-center"><strong>Cost Price</strong></td>
                                                <td class="text-right"><strong>Total Cost Price</strong></td>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $alltotal = 0;
                                            ?>
                                            <?php $__currentLoopData = $porder->purchase_order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $alltotal+= $total = $item->qty * $item->cost_price;
                                                ?>
                                                <tr>
                                                    <td><?php echo e($item->stock()->get()->first()->name); ?></td>
                                                    <td class="text-center"><?php echo e($item->qty); ?></td>
                                                    <td class="text-center"><?php echo e(number_format($item->cost_price,2)); ?></td>
                                                    <td class="text-right"><?php echo e(number_format($total,2)); ?></td>
                                                </tr>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th class="text-right">Total :</th>
                                                <th class="text-right"><?php echo e(number_format($alltotal,2)); ?></th>
                                            </tr>
                                            </tfoot>
                                        </table>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salespoint\resources\views/purchaseorder/show.blade.php ENDPATH**/ ?>